package com.biz.crm.mdm.tableconfig;

import com.biz.crm.mdm.tableconfig.impl.MdmColumnConfigPersonalFeignImpl;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalRedisVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 字段配置个性设置feign接口
 *
 * @author Tao.Chen
 * @date 2021-02-20 15:30:42
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "mdmColumnConfigPersonalFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmColumnConfigPersonalFeignImpl.class)
public interface MdmColumnConfigPersonalFeign {

    /**
     * 查询个性设置redis缓存数据
     *
     * @param parentCode   菜单编码
     * @param functionCode 功能编码
     * @param positionCode 职位编码
     * @return
     */
    @GetMapping("/mdmColumnConfigPersonalController/findColumnConfigPersonalRedisList")
    Result<List<MdmColumnConfigPersonalRedisVo>> findColumnConfigPersonalRedisList(@RequestParam("parentCode") String parentCode, @RequestParam("functionCode") String functionCode, @RequestParam("positionCode") String positionCode);

}
