package com.biz.crm.mdm.terminal.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.*;
import com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.req.UpdateCoordinateReqVo;
import com.biz.crm.nebular.sfa.audit.req.SfaTPMTerminalReqVo;
import com.biz.crm.nebular.sfa.tpmact.SfaTpmOrgRCusVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author Liao Hua
 * @date 2020/9/3 5:08 下午
 */
@Slf4j
@Component
public class MdmTerminalFeignImpl extends BaseAbstract implements FallbackFactory<MdmTerminalFeign> {

    @Override
    public MdmTerminalFeign create(Throwable throwable) {
        log.error("进入熔断:",throwable);
        return new MdmTerminalFeign() {

            @Override
            public Result<PageResult<MdmTerminalVo>> page(MdmTerminalVo mdmTerminalReqVo) {
                return doBack();
            }

            @Override
            public Result<MdmTerminalVo> query(String id, String terminalCode) {
                return doBack();
            }

            @Override
            public Result<MdmTerminalVo> save(MdmTerminalVo mdmTerminalVo) {
                return doBack();
            }

            @Override
            public Result<Object> saveTxBatch(MdmTencentMapData mdmTencentMapData) {
                return doBack();
            }

            @Override
            public Result<Object> saveAndSubmit(MdmTerminalVo mdmTerminalVo) {
                return doBack();
            }

            @Override
            public Result<Object> update(MdmTerminalVo mdmTerminalVo) {
                return doBack();
            }

            @Override
            public Result<Object> updateCoordinate(List<UpdateCoordinateReqVo> updateCoordinateReqVos) {
                return doBack();
            }

            @Override
            public Result<Object> delete(List<String> ids) {
                return doBack();
            }

            @Override
            public Result<Object> enable(List<String> ids) {
                return doBack();
            }

            @Override
            public Result<Object> disable(List<String> ids) {
                return doBack();
            }

            @Override
            public Result<List<String>> findByOrgCodeList(List<String> orgCodes) {
                return doBack();
            }

            @Override
            public Result<List<MdmTerminalVo>> findCurrentAndSubTerminalList(List<String> orgCodes) {
                return doBack();
            }

            @Override
            public Result<List<MdmTerminalVo>> listCondition(MdmTerminalVo vo) {
                return doBack();
            }

            @Override
            public Result<List<MdmTerminalVo>> findPositionTerminalList(String posId, String posCode) {
                return doBack();
            }

            @Override
            public Result<List<MdmTerminalVo>> findCurrentAndSybPositionTerminalList(String posId, String posCode) {
                return doBack();
            }

            @Override
            public Result batchUpdateTerminalOrg(MdmOrgTerminalReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result<PageResult<MdmTerminalContactPageVo>> userTerminalContactPage(MdmTerminalContactPageReqVo mdmTerminalContactPageReqVo) {
                return doBack();
            }

            @Override
            public Result<PageResult<MdmTerminalContactPageVo>> terminalContactPage(MdmTerminalContactPageReqVo mdmTerminalContactPageReqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmTerminalContactPageVo>> sfaFindTerminalContactPage(List<String> terminalCodes) {
                return doBack();
            }

            @Override
            public Result<Long> findPositionRelationTerminalCount(String positionCode) {
                return doBack();
            }

            @Override
            public Result<Long> findPositionRelationTerminalCustomerCount(String positionCode) {
                return doBack();
            }

            @Override
            public Result<MdmTerminalVo> findDetailByRegisterOrName(String licenseRegisterNumber, String terminalName) {
                return doBack();
            }

            @Override
            public Result<PageResult<MdmTerminalContactPageVo>> distanceContactPage(MdmTerminalDistanceContactPageReqVo mdmTerminalDistanceContactPageReqVo) {
                return doBack();
            }

            @Override
            public Result<PageResult<MdmTerminalContactPageVo>> distanceContactNoBpmFilterPage(MdmTerminalDistanceContactPageReqVo mdmTerminalDistanceContactPageReqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmTerminalVo>> customerTerminalList(MdmCustomerTerminalVo mdmCustomerTerminalVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmOrgRespVo>> detailBatch(MdmTerminalVo vo) {
                return doBack();
            }

            @Override
            public Result<PageResult<MdmTerminalContactPageVo>> findTerminalAndContactList(MdmTerminalCurrentAndSubVo mdmTerminalCurrentAndSubVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmTerminalSupplyVo>> findTerminalSupply(MdmTerminalVo mdmTerminalVo) {
                return doBack();
            }

            @Override
            public Result<Boolean> checkTerminalCodeRelByOrgCodeList(List<String> orgCodeList, String terminalCode) {
                return doBack();
            }

            @Override
            public Result<Boolean> checkTerminalCodeRelByCustomerCodeList(List<String> customerCodeList, String terminalCode) {
                return doBack();
            }

            @Override
            public Result<List<String>> checkTerminalCodeRelByOrgOrCusCode(SfaTpmOrgRCusVo orgRCusVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmTerminalVo>> findTerminalByCustomerOrgCodeList(List<String> customerOrgCodeList) {
                return doBack();
            }

            @Override
            public Result<MdmTerminalVo> findTerminalByNameOrAddress(String terminalName,
                String terminalAddress) {
                return doBack();
            }

            @Override
            public Result<List<MdmTerminalVo>> queryTerminalAndAttachByCode(List<String> terminalCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmTerminalVo>> getTerminalByPhone(String phoneCode) {
                return doBack();
            }

            @Override
            public Result<List<MdmTerminalVo>> queryTerminalByOrgCodeList(SfaTPMTerminalReqVo reqVo) {
                return null;
            }
        };
    }
}
