package com.biz.crm.mdm.terminal.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.mdm.terminal.MdmTerminalSupplyFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author Liao Hua
 * @date 2020/9/3 5:08 下午
 */
@Slf4j
@Component
public class MdmTerminalSupplyFeignImpl extends BaseAbstract implements FallbackFactory<MdmTerminalSupplyFeign> {

    @Override
    public MdmTerminalSupplyFeign create(Throwable throwable) {
        log.error("进入熔断:", throwable);
        return new MdmTerminalSupplyFeign() {
            @Override
            public Result<List<MdmCustomerRespVo>> findBySupply(MdmTerminalSupplyVo mdmTerminalSupplyVo) {
                return doBack();
            }
        };
    }
}
