package com.biz.crm.sfa.acttask;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.acttask.req.SfaActFileReqVo;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActFileRespVo;
import com.biz.crm.sfa.acttask.impl.SfaActFileFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 活动附件（示例图片） feign接口
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaActFileFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaActFileFeignImpl.class)
public interface SfaActFileFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaactfile/list")
    Result<PageResult<SfaActFileRespVo>> list(@RequestBody SfaActFileReqVo sfaActFileReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaactfile/query")
    Result<SfaActFileRespVo> query(@RequestBody SfaActFileReqVo sfaActFileReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaactfile/save")
    Result save(@RequestBody SfaActFileReqVo sfaActFileReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaactfile/update")
    Result update(@RequestBody SfaActFileReqVo sfaActFileReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaactfile/delete")
    Result delete(@RequestBody SfaActFileReqVo sfaActFileReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaactfile/enable")
    Result enable(@RequestBody SfaActFileReqVo sfaActFileReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaactfile/disable")
    Result disable(@RequestBody SfaActFileReqVo sfaActFileReqVo);
}
