package com.biz.crm.sfa.acttask.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.acttask.req.SfaActProductReqVo;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActProductRespVo;
import com.biz.crm.sfa.acttask.SfaActProductFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 活动任务管理-陈列要求 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
@Slf4j
@Component
public class SfaActProductFeignImpl extends BaseAbstract implements FallbackFactory<SfaActProductFeign> {

    @Override
    public SfaActProductFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaActProductFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaActProductRespVo>> list(SfaActProductReqVo sfaActProductReqVo) {
                doBack();
                PageResult<SfaActProductRespVo> build = PageResult.<SfaActProductRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaActProductRespVo> query(SfaActProductReqVo sfaActProductReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaActProductReqVo sfaActProductReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaActProductReqVo sfaActProductReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaActProductReqVo sfaActProductReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaActProductReqVo sfaActProductReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaActProductReqVo sfaActProductReqVo) {
                return doBack();
            }
        };
    }
}
