package com.biz.crm.sfa.audit;

import com.biz.crm.sfa.audit.impl.SfaAuditProductPriceFeignImpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditProductPriceRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditProductPriceReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;


/**
 * 产品价格稽查主表feign接口
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaAuditProuditPriceFeign",name="crm-sfa",path = "tpm",fallbackFactory = SfaAuditProductPriceFeignImpl.class)
public interface SfaAuditProductPriceFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaauditprouditprice/list")
    Result<PageResult<SfaAuditProductPriceRespVo>> list(@RequestBody SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaauditprouditprice/query")
    Result<SfaAuditProductPriceRespVo> query(@RequestBody SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaauditprouditprice/save")
    Result save(@RequestBody SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaauditprouditprice/update")
    Result update(@RequestBody SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaauditprouditprice/delete")
    Result delete(@RequestBody SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaauditprouditprice/enable")
    Result enable(@RequestBody SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaauditprouditprice/disable")
    Result disable(@RequestBody SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo);
}
