package com.biz.crm.sfa.audit;

import com.biz.crm.sfa.audit.impl.SfaAuditTpmFeignImpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTpmRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTpmReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;


/**
 * TPM稽查表feign接口
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaAuditTpmFeign",name="crm-sfa",path = "tpm",fallbackFactory = SfaAuditTpmFeignImpl.class)
public interface SfaAuditTpmFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaaudittpm/list")
    Result<PageResult<SfaAuditTpmRespVo>> list(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaaudittpm/query")
    Result<SfaAuditTpmRespVo> query(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaaudittpm/save")
    Result save(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaaudittpm/update")
    Result update(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaaudittpm/delete")
    Result delete(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaaudittpm/enable")
    Result enable(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaaudittpm/disable")
    Result disable(@RequestBody  SfaAuditTpmReqVo sfaAuditTpmReqVo);
}
