package com.biz.crm.sfa.audit.impl;

import com.biz.crm.sfa.audit.SfaAuditAttendanceFeign;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditAttendanceRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditAttendanceReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;

import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * 考勤稽查表feign接口熔断类
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@Component
public class SfaAuditAttendanceFeignImpl extends BaseAbstract implements FallbackFactory<SfaAuditAttendanceFeign> {

    @Override
    public SfaAuditAttendanceFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaAuditAttendanceFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaAuditAttendanceRespVo>> list(SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo) {
                doBack();
                PageResult<SfaAuditAttendanceRespVo> build = PageResult.<SfaAuditAttendanceRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaAuditAttendanceRespVo> query(SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo) {
                return doBack();
            }
        };
    }
}
