package com.biz.crm.sfa.audit.impl;

import com.biz.crm.sfa.audit.SfaAuditInspectorsFeign;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditInspectorsRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditInspectorsReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;

import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * 稽查人员区域配置表feign接口熔断类
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@Component
public class SfaAuditInspectorsFeignImpl extends BaseAbstract implements FallbackFactory<SfaAuditInspectorsFeign> {

    @Override
    public SfaAuditInspectorsFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaAuditInspectorsFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaAuditInspectorsRespVo>> list(SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo) {
                doBack();
                PageResult<SfaAuditInspectorsRespVo> build = PageResult.<SfaAuditInspectorsRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaAuditInspectorsRespVo> query(SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo) {
                return doBack();
            }
        };
    }
}
