package com.biz.crm.sfa.audit.impl;

import com.biz.crm.sfa.audit.SfaAuditProductPriceProFeign;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditProductPriceProRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditProductPriceProReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;

import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * 产品价格稽查-产品表feign接口熔断类
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@Component
public class SfaAuditProductPriceProFeignImpl extends BaseAbstract implements FallbackFactory<SfaAuditProductPriceProFeign> {

    @Override
    public SfaAuditProductPriceProFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaAuditProductPriceProFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaAuditProductPriceProRespVo>> list(SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo) {
                doBack();
                PageResult<SfaAuditProductPriceProRespVo> build = PageResult.<SfaAuditProductPriceProRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaAuditProductPriceProRespVo> query(SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo) {
                return doBack();
            }
        };
    }
}
