package com.biz.crm.sfa.audit.impl;

import com.biz.crm.sfa.audit.SfaAuditTransregionalFeign;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTransregionalRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTransregionalReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;

import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * 窜货稽查表feign接口熔断类
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@Component
public class SfaAuditTransregionalFeignImpl extends BaseAbstract implements FallbackFactory<SfaAuditTransregionalFeign> {

    @Override
    public SfaAuditTransregionalFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaAuditTransregionalFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaAuditTransregionalRespVo>> list(SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo) {
                doBack();
                PageResult<SfaAuditTransregionalRespVo> build = PageResult.<SfaAuditTransregionalRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaAuditTransregionalRespVo> query(SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo) {
                return doBack();
            }
        };
    }
}
