package com.biz.crm.sfa.notice;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeFileReqVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeFileRespVo;
import com.biz.crm.sfa.notice.impl.SfaNoticeFileFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 公告附件 feign接口
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaNoticeFileFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaNoticeFileFeignImpl.class)
public interface SfaNoticeFileFeign {

    /**
     * 列表
     */
    @PostMapping("/sfanoticefile/list")
    Result<PageResult<SfaNoticeFileRespVo>> list(@RequestBody SfaNoticeFileReqVo sfaNoticeFileReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfanoticefile/query")
    Result<SfaNoticeFileRespVo> query(@RequestBody SfaNoticeFileReqVo sfaNoticeFileReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfanoticefile/save")
    Result save(@RequestBody SfaNoticeFileReqVo sfaNoticeFileReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfanoticefile/update")
    Result update(@RequestBody SfaNoticeFileReqVo sfaNoticeFileReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfanoticefile/delete")
    Result delete(@RequestBody SfaNoticeFileReqVo sfaNoticeFileReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfanoticefile/enable")
    Result enable(@RequestBody SfaNoticeFileReqVo sfaNoticeFileReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfanoticefile/disable")
    Result disable(@RequestBody SfaNoticeFileReqVo sfaNoticeFileReqVo);
}
