package com.biz.crm.sfa.notice;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReadReqVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeReadRespVo;
import com.biz.crm.sfa.notice.impl.SfaNoticeReadFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 公告读取信息 feign接口
 *
 * @author liuhongming
 * @date 2020-09-17 19:12:50
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaNoticeReadFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaNoticeReadFeignImpl.class)
public interface SfaNoticeReadFeign {

    /**
     * 列表
     */
    @PostMapping("/sfanoticeread/list")
    Result<PageResult<SfaNoticeReadRespVo>> list(@RequestBody SfaNoticeReadReqVo sfaNoticeReadReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfanoticeread/query")
    Result<SfaNoticeReadRespVo> query(@RequestBody SfaNoticeReadReqVo sfaNoticeReadReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfanoticeread/save")
    Result save(@RequestBody SfaNoticeReadReqVo sfaNoticeReadReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfanoticeread/update")
    Result update(@RequestBody SfaNoticeReadReqVo sfaNoticeReadReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfanoticeread/delete")
    Result delete(@RequestBody SfaNoticeReadReqVo sfaNoticeReadReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfanoticeread/enable")
    Result enable(@RequestBody SfaNoticeReadReqVo sfaNoticeReadReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfanoticeread/disable")
    Result disable(@RequestBody SfaNoticeReadReqVo sfaNoticeReadReqVo);
}
