package com.biz.crm.sfa.notice.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeFileReqVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeFileRespVo;
import com.biz.crm.sfa.notice.SfaNoticeFileFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 公告附件 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */
@Slf4j
@Component
public class SfaNoticeFileFeignImpl extends BaseAbstract implements FallbackFactory<SfaNoticeFileFeign> {

    @Override
    public SfaNoticeFileFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaNoticeFileFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaNoticeFileRespVo>> list(SfaNoticeFileReqVo sfaNoticeFileReqVo) {
                doBack();
                PageResult<SfaNoticeFileRespVo> build = PageResult.<SfaNoticeFileRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaNoticeFileRespVo> query(SfaNoticeFileReqVo sfaNoticeFileReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaNoticeFileReqVo sfaNoticeFileReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaNoticeFileReqVo sfaNoticeFileReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaNoticeFileReqVo sfaNoticeFileReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaNoticeFileReqVo sfaNoticeFileReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaNoticeFileReqVo sfaNoticeFileReqVo) {
                return doBack();
            }
        };
    }
}
