package com.biz.crm.sfa.visitnote;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRespVo;
import com.biz.crm.sfa.visitnote.impl.SfaVisitPlanFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 拜访计划制定 feign接口
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitPlanFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitPlanFeignImpl.class)
public interface SfaVisitPlanFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaVisitPlanController/list")
    Result<PageResult<SfaVisitPlanRespVo>> list(@RequestBody SfaVisitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaVisitPlanController/query")
    Result<SfaVisitPlanRespVo> query(@RequestBody SfaVisitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaVisitPlanController/save")
    Result save(@RequestBody SfaVisitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaVisitPlanController/update")
    Result update(@RequestBody SfaVisitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaVisitPlanController/delete")
    Result delete(@RequestBody SfaVisitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaVisitPlanController/enable")
    Result enable(@RequestBody SfaVisitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaVisitPlanController/disable")
    Result disable(@RequestBody SfaVisitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 手动跑拜访制定计划规则
     * @param sfaVisitPlanInfoReqVo
     * @return
     */
    @PostMapping("/sfaVisitPlanController/produceSfaVisitRule")
    Result produceSfaVisitRule(@RequestBody SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo);


    /**
     * 定时任务——触发解析拜访计划
     * @return
     */
    @PostMapping("/sfaVisitPlanController/resolveVisitPlanForJob")
    Result resolveVisitPlanForJob();

}
