package com.biz.crm.sfa.visitnote;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanRangeReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRangeRespVo;
import com.biz.crm.sfa.visitnote.impl.SfaVisitPlanRangeFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 拜访计划制定范围表 feign接口
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitPlanRangeFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitPlanRangeFeignImpl.class)
public interface SfaVisitPlanRangeFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisitplanrange/list")
    Result<PageResult<SfaVisitPlanRangeRespVo>> list(@RequestBody SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisitplanrange/query")
    Result<SfaVisitPlanRangeRespVo> query(@RequestBody SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisitplanrange/save")
    Result save(@RequestBody SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisitplanrange/update")
    Result update(@RequestBody SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisitplanrange/delete")
    Result delete(@RequestBody SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisitplanrange/enable")
    Result enable(@RequestBody SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisitplanrange/disable")
    Result disable(@RequestBody SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo);
}
