package com.biz.crm.sfa.visitstep;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepInoutReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepInoutRespVo;
import com.biz.crm.sfa.visitstep.impl.SfaVisitStepInoutFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 拜访步骤(进离店) feign接口
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitStepInoutFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitStepInoutFeignImpl.class)
public interface SfaVisitStepInoutFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisitstepinout/list")
    Result<PageResult<SfaVisitStepInoutRespVo>> list(@RequestBody SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisitstepinout/query")
    Result<SfaVisitStepInoutRespVo> query(@RequestBody SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisitstepinout/save")
    Result save(@RequestBody SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisitstepinout/update")
    Result update(@RequestBody SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisitstepinout/delete")
    Result delete(@RequestBody SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisitstepinout/enable")
    Result enable(@RequestBody SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisitstepinout/disable")
    Result disable(@RequestBody SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo);
}
