package com.biz.crm.sfa.visitstep.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletRespVo;
import com.biz.crm.sfa.visitstep.SfaVisitStepColletFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 拜访步骤(竞品采集);feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@Component
public class SfaVisitStepColletFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitStepColletFeign> {

    @Override
    public SfaVisitStepColletFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitStepColletFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitStepColletRespVo>> list(SfaVisitStepColletReqVo sfaVisitStepColletReqVo) {
                doBack();
                PageResult<SfaVisitStepColletRespVo> build = PageResult.<SfaVisitStepColletRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitStepColletRespVo> query(SfaVisitStepColletReqVo sfaVisitStepColletReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitStepColletReqVo sfaVisitStepColletReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitStepColletReqVo sfaVisitStepColletReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitStepColletReqVo sfaVisitStepColletReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitStepColletReqVo sfaVisitStepColletReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitStepColletReqVo sfaVisitStepColletReqVo) {
                return doBack();
            }
        };
    }
}
