package com.biz.crm.sfa.worksign;

import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.sfa.worksign.impl.SfaWorkSignOvertimeEndFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author ren.gang
 * @ClassName SfaWorkSignOvertimeEndFeign.java
 * @Description 工作日调整流程结束
 * @createTime 2020年12月16日 10:15:00
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "SfaWorkSignOvertimeEndFeign"
        ,name="crm-sfa",path = "sfa",fallbackFactory = SfaWorkSignOvertimeEndFeignImpl.class)
public interface SfaWorkSignOvertimeEndFeign extends CallbackFeign {

    /**
     * 流程结束
     * @param activitiCallBackVo
     * @return
     */
    @PostMapping("/sfaWorkSignAudit/overtimeEnd")
    Result callback(ActivitiCallBackVo activitiCallBackVo);
}
