package com.biz.crm.sfa.worksign.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRecordReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.sfa.worksign.SfaWorkSignRecordFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 考勤打卡记录表 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Slf4j
@Component
public class SfaWorkSignRecordFeignImpl extends BaseAbstract implements FallbackFactory<SfaWorkSignRecordFeign> {

    @Override
    public SfaWorkSignRecordFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaWorkSignRecordFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaWorkSignRecordRespVo>> list(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
                doBack();
                PageResult<SfaWorkSignRecordRespVo> build = PageResult.<SfaWorkSignRecordRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaWorkSignRecordRespVo> query(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
                return doBack();
            }
        };
    }
}
