package com.biz.crm.sfa.worksignrule;

import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignExecuteReqVo;
import com.biz.crm.sfa.worksignrule.impl.SfaWorkSignExecuteFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author ren.gang
 * @ClassName SfaWorkSignExecuteFeign.java
 * @Description TODO
 * @createTime 2020年12月31日 14:43:00
 */
@FeignClient(
        url ="${feign.urlip:}",
        qualifier = "SfaWorkSignExecuteFeign",
        name="crm-sfa",
        path = "sfa",
        fallbackFactory = SfaWorkSignExecuteFeignImpl.class
)
public interface SfaWorkSignExecuteFeign {

    /**
     * 执行考勤规则，生成指定日期的考勤数据
     * @param reqVo
     * @return
     */
    @PostMapping("/sfaworksignrule/executeWorkSignRule")
    Result executeWorkSignRule(@RequestBody SfaWorkSignExecuteReqVo reqVo);
}
