package com.biz.crm.tpm.account;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountInvoiceRespVo;
import com.biz.crm.tpm.account.impl.TpmAccountInvoiceFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 费用上账发票关联表;feign接口
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmAccountInvoiceFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmAccountInvoiceFeignImpl.class)
public interface TpmAccountInvoiceFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmaccountinvoice/list")
    Result<PageResult<TpmAccountInvoiceRespVo>> list(@RequestBody TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmaccountinvoice/query")
    Result<TpmAccountInvoiceRespVo> query(@RequestBody TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmaccountinvoice/save")
    Result save(@RequestBody TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmaccountinvoice/update")
    Result update(@RequestBody TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmaccountinvoice/delete")
    Result delete(@RequestBody TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmaccountinvoice/enable")
    Result enable(@RequestBody TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmaccountinvoice/disable")
    Result disable(@RequestBody  TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo);
}
