package com.biz.crm.tpm.act.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.act.TpmActDetailFeign;
import feign.hystrix.FallbackFactory;

import java.util.ArrayList;

/**
 * 活动明细信息表;feign接口熔断类
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Slf4j
@Component
public class TpmActDetailFeignImpl extends BaseAbstract implements FallbackFactory<TpmActDetailFeign> {

    @Override
    public TpmActDetailFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmActDetailFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmActDetailRespVo>> list(TpmActDetailReqVo tpmActDetailReqVo) {
                doBack();
                PageResult<TpmActDetailRespVo> build = PageResult.<TpmActDetailRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            @Override
            public Result<PageResult<TpmActDetailRespVo>> pageForAdvancePay(TpmActDetailReqVo tpmActDetailReqVo) {
                doBack();
                PageResult<TpmActDetailRespVo> build = PageResult.<TpmActDetailRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmActDetailRespVo> query(TpmActDetailReqVo tpmActDetailReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmActDetailReqVo tpmActDetailReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmActDetailReqVo tpmActDetailReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmActDetailReqVo tpmActDetailReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmActDetailReqVo tpmActDetailReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmActDetailReqVo tpmActDetailReqVo) {
                return doBack();
            }
        };
    }
}
