package com.biz.crm.tpm.advancepay;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.advancepay.resp.TpmActAdvancePayDetailRespVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayDetailReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import com.biz.crm.tpm.advancepay.impl.TpmActAdvancePayDetailFeignImpl;

/**
 * 活动预付明细表 feign接口
 *
 * @author huanglong
 * @date 2020-09-27 10:46:08
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmActAdvancePayDetailFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmActAdvancePayDetailFeignImpl.class)
public interface TpmActAdvancePayDetailFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmactadvancepaydetail/list")
    Result<PageResult<TpmActAdvancePayDetailRespVo>> list(@RequestBody TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmactadvancepaydetail/query")
    Result<TpmActAdvancePayDetailRespVo> query(@RequestBody TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmactadvancepaydetail/save")
    Result save(@RequestBody TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmactadvancepaydetail/update")
    Result update(@RequestBody TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmactadvancepaydetail/delete")
    Result delete(@RequestBody TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmactadvancepaydetail/enable")
    Result enable(@RequestBody TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmactadvancepaydetail/disable")
    Result disable(@RequestBody TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo);
}
