package com.biz.crm.tpm.audit;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditActRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditActReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import com.biz.crm.tpm.audit.impl.TpmAuditActFeignImpl;

/**
 * 核销申请活动表 feign接口
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmAuditActFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmAuditActFeignImpl.class)
public interface TpmAuditActFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmauditact/list")
    Result<PageResult<TpmAuditActRespVo>> list(@RequestBody TpmAuditActReqVo tpmAuditActReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmauditact/query")
    Result<TpmAuditActRespVo> query(@RequestBody TpmAuditActReqVo tpmAuditActReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmauditact/save")
    Result save(@RequestBody TpmAuditActReqVo tpmAuditActReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmauditact/update")
    Result update(@RequestBody TpmAuditActReqVo tpmAuditActReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmauditact/delete")
    Result delete(@RequestBody TpmAuditActReqVo tpmAuditActReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmauditact/enable")
    Result enable(@RequestBody TpmAuditActReqVo tpmAuditActReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmauditact/disable")
    Result disable(@RequestBody TpmAuditActReqVo tpmAuditActReqVo);
}
