package com.biz.crm.tpm.audit;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditRespVo;
import com.biz.crm.tpm.audit.impl.TpmAuditFeignImpl;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 核销申请主表 feign接口
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmAuditFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmAuditFeignImpl.class)
public interface TpmAuditFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmaudit/list")
    Result<PageResult<TpmAuditRespVo>> list(@RequestBody TpmAuditReqVo tpmAuditReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmaudit/query")
    Result<TpmAuditRespVo> query(@RequestBody TpmAuditReqVo tpmAuditReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmaudit/save")
    Result save(@RequestBody TpmAuditReqVo tpmAuditReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmaudit/update")
    Result update(@RequestBody TpmAuditReqVo tpmAuditReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmaudit/delete")
    Result delete(@RequestBody TpmAuditReqVo tpmAuditReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmaudit/enable")
    Result enable(@RequestBody TpmAuditReqVo tpmAuditReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmaudit/disable")
    Result disable(@RequestBody TpmAuditReqVo tpmAuditReqVo);

    /**
     *  核销申请新增的活动明细列表
     * @param reqVo
     * @return
     */
    @PostMapping("/tpmaudit/actDetailList")
    Result<PageResult<TpmActDetailRespVo>> actDetailList(@RequestBody TpmActDetailReqVo reqVo);

    /**
     * 核销申请新增时查询活动列表
     * @param tpmActReqVo
     * @return
     */
    @ApiOperation(value = "核销申请新增时查询活动列表")
    @PostMapping("/tpmaudit/actList")
    Result<PageResult<TpmActRespVo>> actList(@RequestBody TpmActReqVo tpmActReqVo);

    /**
     *  核销审批
     * @param reqVo
     * @return Result
     */
    @PostMapping("/tpmaudit/auditApproved")
    Result auditApproved(@RequestBody TpmAuditReqVo reqVo);
}
