package com.biz.crm.tpm.audit;

import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.tpm.audit.impl.TpmAuditCallBackFeignImpl;
import com.biz.crm.tpm.liqueuract.impl.TpmLiqueurActCallBackFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 酒类核销审批回调;feign接口
 *
 * @author jerry7
 * @date 2021-03-29 09:46:33
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmLiqueurAuditCallBackFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmLiqueurActCallBackFeignImpl.class)
public interface TpmLiqueurAuditCallBackFeign extends CallbackFeign {

    /**
     * 回调方法
     * @param activitiCallBackVo
     * @return
     */
    @Override
    @PostMapping("/tpmliqueuraudit/liqueurAuditCallBack")
    Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo);
}
