package com.biz.crm.tpm.audit.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditFileRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditFileReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.audit.TpmAuditFileFeign;
import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * 核销申请资料表 feign接口熔断类
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Slf4j
@Component
public class TpmAuditFileFeignImpl extends BaseAbstract implements FallbackFactory<TpmAuditFileFeign> {

    @Override
    public TpmAuditFileFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmAuditFileFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmAuditFileRespVo>> list(TpmAuditFileReqVo tpmAuditFileReqVo) {
                doBack();
                PageResult<TpmAuditFileRespVo> build = PageResult.<TpmAuditFileRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmAuditFileRespVo> query(TpmAuditFileReqVo tpmAuditFileReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmAuditFileReqVo tpmAuditFileReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmAuditFileReqVo tpmAuditFileReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmAuditFileReqVo tpmAuditFileReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmAuditFileReqVo tpmAuditFileReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmAuditFileReqVo tpmAuditFileReqVo) {
                return doBack();
            }
        };
    }
}
