package com.biz.crm.tpm.budgetsubjects;

import com.biz.crm.common.PageResult;
import com.biz.crm.tpm.budgetsubjects.impl.TpmBudgetSubjectsFeignImpl;
import com.biz.crm.nebular.tpm.budgetsubjects.req.TpmBudgetSubjectsReqVo;
import com.biz.crm.nebular.tpm.budgetsubjects.resp.TpmBudgetSubjectsRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 预算科目 feign接口
 *
 * @author huang.long
 * @date 2020-09-09 13:40:31
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmBudgetSubjectsFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmBudgetSubjectsFeignImpl.class)
public interface TpmBudgetSubjectsFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmbudgetsubjects/list")
    Result<PageResult<TpmBudgetSubjectsRespVo>> list(@RequestBody TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmbudgetsubjects/query")
    Result<TpmBudgetSubjectsRespVo> query(@RequestBody TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmbudgetsubjects/save")
    Result save(@RequestBody TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmbudgetsubjects/update")
    Result update(@RequestBody TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmbudgetsubjects/delete")
    Result delete(@RequestBody TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmbudgetsubjects/enable")
    Result enable(@RequestBody TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmbudgetsubjects/disable")
    Result disable(@RequestBody TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo);
}
