package com.biz.crm.tpm.costtypecategories;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRangeRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesRangeReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.tpm.costtypecategories.impl.TpmCostTypeCategoriesRangeFeignImpl;

/**
 * 活动大类范围表;feign接口
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TmpCostTypeCategoriesRangeFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmCostTypeCategoriesRangeFeignImpl.class)
public interface TpmCostTypeCategoriesRangeFeign {

    /**
     * 列表
     */
    @PostMapping("/tmpcosttypecategoriesrange/list")
    Result<PageResult<TpmCostTypeCategoriesRangeRespVo>> list(@RequestBody TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo);

    /**
     * 查询
     */
    @PostMapping("/tmpcosttypecategoriesrange/query")
    Result<TpmCostTypeCategoriesRangeRespVo> query(@RequestBody TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo);

    /**
     * 新增
     */
    @PostMapping("/tmpcosttypecategoriesrange/save")
    Result save(@RequestBody TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo);

    /**
     * 更新
     */
    @PostMapping("/tmpcosttypecategoriesrange/update")
    Result update(@RequestBody TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo);

    /**
     * 删除
     */
    @PostMapping("/tmpcosttypecategoriesrange/delete")
    Result delete(@RequestBody TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo);

    /**
     * 启用
     */
    @PostMapping("/tmpcosttypecategoriesrange/enable")
    Result enable(@RequestBody TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tmpcosttypecategoriesrange/disable")
    Result disable(@RequestBody TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo);
}
