package com.biz.crm.tpm.costtypecategories.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesFineRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesFineReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.costtypecategories.TpmCostTypeCategoriesFineFeign;
import feign.hystrix.FallbackFactory;

import java.util.ArrayList;

/**
 * 活动大类与活动细类的关联表 feign接口熔断类
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
@Slf4j
@Component
public class TpmCostTypeCategoriesFineFeignImpl extends BaseAbstract implements FallbackFactory<TpmCostTypeCategoriesFineFeign> {

    @Override
    public TpmCostTypeCategoriesFineFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmCostTypeCategoriesFineFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmCostTypeCategoriesFineRespVo>> list(TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo) {
                doBack();
                PageResult<TpmCostTypeCategoriesFineRespVo> build = PageResult.<TpmCostTypeCategoriesFineRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmCostTypeCategoriesFineRespVo> query(TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo) {
                return doBack();
            }
        };
    }
}
