package com.biz.crm.tpm.costtypefine;

import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.tpm.costtypefine.impl.TpmCostTypeFineFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 活动细类 feign接口
 *
 * @author huanglong
 * @date 2020-09-14 11:01:38
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmCostTypeFineFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmCostTypeFineFeignImpl.class)
public interface TpmCostTypeFineFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmcosttypefine/list")
    Result<PageResult<TpmCostTypeFineRespVo>> list(@RequestBody TpmCostTypeFineReqVo tpmCostTypeFineReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmcosttypefine/query")
    Result<TpmCostTypeFineRespVo> query(@RequestBody TpmCostTypeFineReqVo tpmCostTypeFineReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmcosttypefine/save")
    Result save(@RequestBody TpmCostTypeFineReqVo tpmCostTypeFineReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmcosttypefine/update")
    Result update(@RequestBody TpmCostTypeFineReqVo tpmCostTypeFineReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmcosttypefine/delete")
    Result delete(@RequestBody TpmCostTypeFineReqVo tpmCostTypeFineReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmcosttypefine/enable")
    Result enable(@RequestBody TpmCostTypeFineReqVo tpmCostTypeFineReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmcosttypefine/disable")
    Result disable(@RequestBody TpmCostTypeFineReqVo tpmCostTypeFineReqVo);

    /**
     * 核销申请中核销资料
     * @param fineCodes
     * @return
     */
    @PostMapping("/tpmcosttypefine/costTypeFineListByFineCode")
    Result<TpmCostTypeFineRespVo> costTypeFineListByFineCode(@RequestBody List<String> fineCodes);

    /**
     * 活动细类,根据细类编码查询细类关联的活动大类集合
     * @param reqVo
     * @return
     */
    @PostMapping("/tpmcosttypefine/findCategoriesByFineCode")
    Result<PageResult<TpmCostTypeCategoriesRespVo>> findCategoriesByFineCode(@RequestBody  TpmCostTypeFineReqVo reqVo);

    /**
     * @Description  根据细类编码查询  ERP会计科目编码
     * @Date 2020/10/30
     * @Param [tpmCostTypeFineReqVo]
     * @return com.biz.crm.util.Result<java.util.List<com.biz.crm.common.DictItemVo>>
     **/
    @PostMapping("/tpmcosttypefine/financeSubjectsErpCodeByFindCode")
    Result<List<TpmCostTypeFineRespVo>> financeSubjectsErpCodeByFindCode(@RequestBody TpmAccountInvoiceReqVo reqVo);

}
