package com.biz.crm.tpm.income;

import com.biz.crm.nebular.tpm.income.req.TpmIncomeBudgetReqVo;
import com.biz.crm.nebular.tpm.income.resp.TpmIncomeBudgetRespVo;
import com.biz.crm.tpm.income.impl.TpmIncomeBudgetFeignImpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;


/**
 * 收入预算;feign接口
 *
 * @author lf
 * @date 2021-02-02 17:55:15
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmIncomeBudgetFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmIncomeBudgetFeignImpl.class)
public interface TpmIncomeBudgetFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmincomebudget/list")
    Result<PageResult<TpmIncomeBudgetRespVo>> list(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmincomebudget/query")
    Result<TpmIncomeBudgetRespVo> query(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmincomebudget/save")
    Result save(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmincomebudget/update")
    Result update(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmincomebudget/delete")
    Result delete(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmincomebudget/enable")
    Result enable(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmincomebudget/disable")
    Result disable(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo);
}
