package com.biz.crm.tpm.scales.impl;

import com.biz.crm.nebular.tpm.sale.req.TpmSalesPlansReqVo;
import com.biz.crm.nebular.tpm.sale.resp.TpmSalesPlansRespVo;
import com.biz.crm.tpm.scales.TpmSalesPlansFeign;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import java.util.ArrayList;

/**
 * 销售计划 feign接口熔断类
 *
 * @author jerry7
 * @date 2021-04-28 15:32:39
 */
@Slf4j
@Component
public class TpmSalesPlansFeignImpl extends BaseAbstract implements FallbackFactory<TpmSalesPlansFeign> {

    @Override
    public TpmSalesPlansFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmSalesPlansFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmSalesPlansRespVo>> list(TpmSalesPlansReqVo tpmSalesPlansReqVo) {
                doBack();
                PageResult<TpmSalesPlansRespVo> build = PageResult.<TpmSalesPlansRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmSalesPlansRespVo> query(TpmSalesPlansReqVo tpmSalesPlansReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmSalesPlansReqVo tpmSalesPlansReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmSalesPlansReqVo tpmSalesPlansReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmSalesPlansReqVo tpmSalesPlansReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmSalesPlansReqVo tpmSalesPlansReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmSalesPlansReqVo tpmSalesPlansReqVo) {
                return doBack();
            }
        };
    }
}
