package com.biz.crm.webservice.message;

import com.biz.crm.message.ShortMessage;
import com.biz.crm.util.Result;
import com.biz.crm.webservice.message.impl.ShortMessageFeignImpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(url = "${feign.urlip:}", qualifier = "ShortMessageFeign", name = "crm-webservice", path = "service", fallbackFactory = ShortMessageFeignImpl.class)
public interface ShortMessageFeign {


    @PostMapping("/aliyuncs/shortMessageController/sendMessage")
    Result<Boolean> sendMessage(@RequestBody ShortMessage shortMessage);


}