package com.biz.crm.activiti.act;

import com.biz.crm.activiti.act.impl.TaActBaseFeignImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.RushProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActBaseReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActBaseRespVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.activiti.start.req.CancelProcessReqVO;
import com.biz.crm.nebular.activiti.vo.ActivitiBusinessVo;
import com.biz.crm.nebular.activiti.vo.BpmQueryVo;
import com.biz.crm.nebular.activiti.vo.CurrentTaskVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * feign接口
 *
 * @author jerry7
 * @date 2020-12-05 15:36:45
 */


@FeignClient(url = "${feign.urlip:}", qualifier = "TaActBaseFeign", name = "crm-activiti", path = "activiti", fallbackFactory = TaActBaseFeignImpl.class)
public interface TaActBaseFeign {

    /**
     * 列表
     */
    @PostMapping("/taactbase/list")
    Result<PageResult<TaActBaseRespVo>> list(@RequestBody TaActBaseReqVo taActBaseReqVo);

    /**
     * 查询
     */
    @GetMapping("/taactbase/query")
    Result<TaActBaseRespVo> query(@RequestParam("id") String id);

    /**
     * 新增
     */
    @PostMapping("/taactbase/save")
    Result save(@RequestBody TaActBaseReqVo taActBaseReqVo);

    /**
     * 更新
     */
    @PostMapping("/taactbase/update")
    Result update(@RequestBody TaActBaseReqVo taActBaseReqVo);

    /**
     * 删除
     */
    @PostMapping("/taactbase/delete")
    Result delete(@RequestBody List<String> ids);

    /**
     * 发起流程(2.0新版接口)
     *
     * @param activitiBusinessVo
     * @return
     */
    @PostMapping("/runtimeController/startProcess")
    Result<String> startProcess(@RequestBody ActivitiBusinessVo activitiBusinessVo);

    /**
     * 查询我的待办
     * @param bpmQueryVo
     * @return
     */
    @PostMapping("/runtimeController/listByPositionCode")
    Result<PageResult<CurrentTaskVo>> listByPositionCode(@RequestBody BpmQueryVo bpmQueryVo);

    /**
     * 刷新流程状态
     *
     * @param rushProcessReqVo
     * @return
     */
    @PostMapping("/taTaskController/rushProcessState")
    Result rushProcessState(@RequestBody RushProcessReqVo rushProcessReqVo);

    /**
     * 撤销流程
     */
    @PostMapping("/taActBaseController/cancelProcess")
    Result cancelProcess(@RequestBody CancelProcessReqVO cancelProcessReqVO);
}
