package com.biz.crm.activiti.act.impl;

import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.RushProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessFormEngReqVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActBaseReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActBaseRespVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.activiti.start.req.CancelProcessReqVO;
import com.biz.crm.nebular.activiti.vo.ActivitiBusinessVo;
import com.biz.crm.nebular.activiti.vo.BpmQueryVo;
import com.biz.crm.nebular.activiti.vo.CurrentTaskVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.ArrayList;
import java.util.List;

/**
 * feign接口熔断类
 *
 * @author jerry7
 * @date 2020-12-05 15:36:45
 */
@Slf4j
@Component
public class TaActBaseFeignImpl extends BaseAbstract implements FallbackFactory<TaActBaseFeign> {

    @Override
    public TaActBaseFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new TaActBaseFeign() {
            /**
             * 列表
             */
            @Override
            public Result<PageResult<TaActBaseRespVo>> list(TaActBaseReqVo taActBaseReqVo) {
                doBack();
                PageResult<TaActBaseRespVo> build = PageResult.<TaActBaseRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TaActBaseRespVo> query(String id) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TaActBaseReqVo taActBaseReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TaActBaseReqVo taActBaseReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(List<String> ids) {
                return doBack();
            }

            @Override
            public Result<String> startProcess(ActivitiBusinessVo activitiBusinessVo) {
                return doBack();
            }

            @Override
            public Result<PageResult<CurrentTaskVo>> listByPositionCode(BpmQueryVo bpmQueryVo) {
                return doBack();
            }

            @Override
            public Result rushProcessState(RushProcessReqVo rushProcessReqVo) {
                return doBack();
            }

            @Override
            public Result cancelProcess(CancelProcessReqVO cancelProcessReqVO) {
                return doBack();
            }

        };
    }
}
