package com.biz.crm.activiti.act.impl;

import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.activiti.act.TaActProcessFeign;
import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActBaseReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActBaseRespVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.activiti.start.req.CancelProcessReqVO;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.start.req.ProcessInfoReqVO;
import com.biz.crm.nebular.activiti.task.req.CopyTaskReqVO;
import com.biz.crm.nebular.activiti.task.req.FormParamQueryReqVO;
import com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.*;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.ArrayList;
import java.util.List;

/**
 * feign接口熔断类
 *
 * @author jerry7
 * @date 2021-03-11 17:45:45
 */
@Slf4j
@Component
public class TaActProcessFeignImpl extends BaseAbstract implements FallbackFactory<TaActProcessFeign> {

    @Override
    public TaActProcessFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new TaActProcessFeign() {
            @Override
            public Result<PageResult<TaskRspVO>> findCurrentTask(TaskQueryReqVO taskReqVO) {
                return doBack();
            }

            @Override
            public Result<PageResult<TaskRspVO>> findDoneTask(TaskQueryReqVO taskReqVO) {
                return doBack();
            }

            @Override
            public Result<PageResult<TaskRspVO>> findStartTask(TaskQueryReqVO taskReqVO) {
                return doBack();
            }

            @Override
            public Result<PageResult<OptRecordRspVO>> getOptRecords(OptRecordReqVO optRecordReqVO) {
                return doBack();
            }

            @Override
            public Result<ProcessInfoRspVO> getProcessInfo(ProcessInfoReqVO processInfoReqVO) {
                return doBack();
            }

            @Override
            public Result<List<OptLogsRspVO>> getOptLogs(OptRecordReqVO optRecordReqVO) {
                return doBack();
            }

            @Override
            public Result<FormParamQueryRspVO> getProcessFormParam(FormParamQueryReqVO formParamQueryReqVO) {
                return doBack();
            }

            @Override
            public Result<PageResult<CopyTaskRspVO>> findMyCopyTask(CopyTaskReqVO copyTaskReqVO) {
                return doBack();
            }

            @Override
            public Result<Integer> countCopyTask(CopyTaskReqVO copyTaskReqVO) {
                return doBack();
            }
        };
    }
}
