package com.biz.crm.activiti.design.impl;

import com.biz.crm.activiti.design.TaNodeConfigFeign;
import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.design.req.TaNodeConfigReqVo;
import com.biz.crm.nebular.activiti.design.resp.TaNodeConfigRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * feign接口熔断类
 *
 * @author jerry7
 * @date 2020-12-04 10:33:17
 */
@Slf4j
@Component
public class TaNodeConfigFeignImpl extends BaseAbstract implements FallbackFactory<TaNodeConfigFeign> {

    @Override
    public TaNodeConfigFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new TaNodeConfigFeign() {
            /**
             * 列表
             */
            @Override
            public Result<PageResult<TaNodeConfigRespVo>> list(TaNodeConfigReqVo taNodeConfigReqVo) {
                doBack();
                PageResult<TaNodeConfigRespVo> build = PageResult.<TaNodeConfigRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TaNodeConfigRespVo> query(String id) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TaNodeConfigReqVo taNodeConfigReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TaNodeConfigReqVo taNodeConfigReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(List<String> ids) {
                return doBack();
            }
        };
    }
}
