package com.biz.crm.activiti.mobile;

import com.biz.crm.activiti.mobile.impl.ActivitiMobileFeignImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.ReadCopyTaskReqVO;
import com.biz.crm.nebular.activiti.act.req.TaskOptReqVO;
import com.biz.crm.nebular.activiti.start.req.CancelProcessReqVO;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.start.req.ProcessInfoReqVO;
import com.biz.crm.nebular.activiti.task.req.CopyTaskReqVO;
import com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.*;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author ren.gang
 * @ClassName ActivitiMobileFeign.java
 * @Description 工作流移动端相关接口
 * @createTime 2020年11月26日 10:45:00
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "ActivitiMobileFeign"
        ,name="crm-activiti",path = "activiti",fallbackFactory = ActivitiMobileFeignImpl.class)
public interface ActivitiMobileFeign {

    @ApiOperation(value = "节点审批通过")
    @PostMapping("/taTaskController/taskComplete")
    Result taskComplete(@RequestBody TaskOptReqVO taskOptReqVO);

    @ApiOperation(value = "驳回发起节点")
    @PostMapping("/taTaskController/taskReject")
    Result taskReject(@RequestBody TaskOptReqVO taskOptReqVO);

    @ApiOperation(value = "撤销流程")
    @PostMapping("/taActBaseController/cancelProcess")
    Result cancelProcess(@RequestBody CancelProcessReqVO cancelProcessReqVO);

    @ApiOperation(value = "查询我的待办任务")
    @PostMapping("/activitiProcessController/findCurrentTask")
    Result<PageResult<TaskRspVO>> findCurrentTask(@RequestBody TaskQueryReqVO taskReqVO);

    @ApiOperation(value = "查询我的已办任务")
    @PostMapping("/activitiProcessController/findDoneTask")
    Result<PageResult<TaskRspVO>> findDoneTask(@RequestBody TaskQueryReqVO taskReqVO);

    @ApiOperation(value = "查询我发起的任务")
    @PostMapping("/activitiProcessController/findStartTask")
    Result<PageResult<TaskRspVO>> findStartTask(@RequestBody TaskQueryReqVO taskReqVO);

    @ApiOperation(value = "查询流程审批记录")
    @PostMapping("/activitiProcessController/getOptRecords")
    Result<PageResult<OptRecordRspVO>> getOptRecords(@RequestBody OptRecordReqVO optRecordReqVO);

    @ApiOperation(value = "查询流程详细信息")
    @PostMapping("/activitiProcessController/getProcessInfo")
    Result<ProcessInfoRspVO> getProcessInfo(@RequestBody ProcessInfoReqVO processInfoReqVO);

    @ApiOperation(value = "查询流程日志")
    @PostMapping("/activitiProcessController/getOptLogs")
    Result<List<OptLogsRspVO>> getOptLogs(@RequestBody OptRecordReqVO optRecordReqVO);

    @ApiOperation(value = "查询抄送给我的任务")
    @PostMapping("/activitiProcessController/findMyCopyTask")
    Result<PageResult<CopyTaskRspVO>> findMyCopyTask(@RequestBody CopyTaskReqVO copyTaskReqVO);

    @ApiOperation(value = "抄送节点已阅")
    @PostMapping("/taTaskController/readCopyTask")
    Result readCopyTask(@RequestBody ReadCopyTaskReqVO readCopyTaskReqVO);

}
