package com.biz.crm.dms.contract;

import com.biz.crm.common.PageResult;
import com.biz.crm.dms.contract.impl.ContractFeignImpl;
import com.biz.crm.nebular.dms.contract.ContractVo;
import com.biz.crm.util.Result;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/** 合同管理
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/9/27 15:36
 **/
@FeignClient(url ="${feign.urlip:}",qualifier = "contractFeign",name="crm-dms",path = "dms",fallbackFactory = ContractFeignImpl.class)
public interface ContractFeign {

    /**
     * 新增
     */
    @PostMapping(value = "/m/contract/add")
    Result add(@RequestBody ContractVo contractVo);

    /**
     * 修改
     */
    @PostMapping(value = "/m/contract/edit")
    Result edit(@RequestBody ContractVo contractVo);

    /**
     * 通过id查询
     */
    @GetMapping(value = "/m/contract/findById/{id}")
    Result<ContractVo> findById(@PathVariable("id") String id);

    /**
     * 分页搜索合同
     */
    @PostMapping(value = "/m/contract/list")
    Result<PageResult<ContractVo>> list(@RequestBody ContractVo contractVo);

    /**
     * 根据id批量删除
     */
    @PostMapping(value = "/m/contract/delByIds")
    Result<Object> delByIds(@RequestBody ArrayList<String> ids);

    /**
     * 根据查询条件批量删除
     */
    @PostMapping(value = "/m/contract/delByParam")
    Result<Object> delByParam(@RequestBody ContractVo contractVo);

    /**
     * 条件查询合同列表
     * @param contractVo
     * @return
     */
    @PostMapping(value = "findByConditions")
    Result<List<ContractVo>> findByConditions(@RequestBody ContractVo contractVo);
}
