package com.biz.crm.dms.promotion;

import com.biz.crm.common.PageResult;
import com.biz.crm.dms.promotion.impl.DmsPromotionPolicyOrderDetailFeignImpl;
import com.biz.crm.nebular.dms.promotion.policy.req.DmsPromotionPolicyOrderDetailReqVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.DmsPromotionPolicyOrderDetailRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 促销政策订单明细feign接口
 *
 * @author lf
 * @date 2020-12-26 13:34:30
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "DmsPromotionPolicyOrderDetailFeign",name="crm-dms",path = "tpm",fallbackFactory = DmsPromotionPolicyOrderDetailFeignImpl.class)
public interface DmsPromotionPolicyOrderDetailFeign {

    /**
     * 列表
     */
    @PostMapping("/dmsPromotionPolicyOrderDetailController/list")
    Result<PageResult<DmsPromotionPolicyOrderDetailRespVo>> list(@RequestBody DmsPromotionPolicyOrderDetailReqVo dmsPromotionPolicyOrderDetailReqVo);

    /**
     * 查询
     */
    @PostMapping("/dmsPromotionPolicyOrderDetailController/query")
    Result<DmsPromotionPolicyOrderDetailRespVo> query(@RequestBody DmsPromotionPolicyOrderDetailReqVo dmsPromotionPolicyOrderDetailReqVo);

    /**
     * 新增
     */
    @PostMapping("/dmsPromotionPolicyOrderDetailController/save")
    Result save(@RequestBody DmsPromotionPolicyOrderDetailReqVo dmsPromotionPolicyOrderDetailReqVo);

    /**
     * 更新
     */
    @PostMapping("/dmsPromotionPolicyOrderDetailController/update")
    Result update(@RequestBody DmsPromotionPolicyOrderDetailReqVo dmsPromotionPolicyOrderDetailReqVo);

    /**
     * 删除
     */
    @PostMapping("/dmsPromotionPolicyOrderDetailController/delete")
    Result delete(@RequestBody DmsPromotionPolicyOrderDetailReqVo dmsPromotionPolicyOrderDetailReqVo);

    /**
     * 启用
     */
    @PostMapping("/dmsPromotionPolicyOrderDetailController/enable")
    Result enable(@RequestBody DmsPromotionPolicyOrderDetailReqVo dmsPromotionPolicyOrderDetailReqVo);

    /**
     * 禁用
     */
    @PostMapping("/dmsPromotionPolicyOrderDetailController/disable")
    Result disable(@RequestBody  DmsPromotionPolicyOrderDetailReqVo dmsPromotionPolicyOrderDetailReqVo);

    /**
     * 批量锁定促销政策使用明细
     * @param reqVo
     * @return
     */
    @PostMapping("/lockPromotionPolicyOrderDetailBatch")
    Result<Boolean> lockPromotionPolicyOrderDetailBatch(@RequestBody List<DmsPromotionPolicyOrderDetailReqVo> reqVo);

    /**
     * 提交促销政策使用明细
     * @param orderNo
     * @return
     */
    @PostMapping("/commitPromotionPolicyOrderDetail")
    Result<Boolean> commitPromotionPolicyOrderDetail(@RequestParam(name = "orderNo") String orderNo);

    /**
     * 回滚促销政策使用明细
     * @param orderNo
     * @return
     */
    @PostMapping("/rollbackPromotionPolicyOrderDetail")
    Result<Boolean> rollbackPromotionPolicyOrderDetail(@RequestParam(name = "orderNo") String orderNo);
}
