package com.biz.crm.dms.promotion;

import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.common.PageResult;
import com.biz.crm.dms.promotion.impl.PromotionFeignImpl;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionAvailableResp;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionScopeSourceVo;
import com.biz.crm.nebular.dms.promotion.PromotionInfoRespVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyQueryVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;

import java.util.ArrayList;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 * 促销政策
 *  @author: luoqi
 *  @Date: 2020-10-19 18:16
 *  @version: V1.0
 *  @Description:
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "promotionFeign",name="crm-dms",path = "dms",fallbackFactory = PromotionFeignImpl.class)
public interface PromotionFeign extends CallbackFeign {


    /**
     * 通过参数查询促销政策集合(目前需要支持通过促销政策编码集合promotionCodes和是否是查询有效的政策的标识queryEffectiveFlag)
     * @param reqVo
     * @return
     */
    @PostMapping("/promotion/v2/findPromotionsByParam")
    Result<PageResult<PromotionInfoRespVo>> findPromotionsByParamV2(@RequestBody PromotionPolicyQueryVo reqVo);

    /**
     * 通过参数查询促销政策集合(目前需要支持通过促销政策编码集合promotionCodes和是否是查询有效的政策的标识queryEffectiveFlag)
     * @param reqVo
     * @return
     */
    @PostMapping("/promotion/external/findPromotionsByParam")
    Result<PageResult<PromotionInfoRespVo>> findPromotionsByParam(@RequestBody PromotionPolicyQueryVo reqVo);

    /**
     * 创建促销政策
     * @param promotionEditVo
     * @return
     */
    @PostMapping("/promotion/external/create")
    Result<PromotionEditVo> create(@RequestBody PromotionEditVo promotionEditVo);

    /**
     * 更新促销政策
     * @param promotionEditVo
     * @return
     */
    @PostMapping("/promotion/external/update")
    Result<PromotionEditVo> update(@RequestBody PromotionEditVo promotionEditVo);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    @GetMapping("/promotion/external/findDetailsById/{id}")
    public Result<PromotionEditVo> findDetailsById(@PathVariable(name = "id") String id);

    /**
     * 分页查询促销范围数据源
     * @param param
     * @return
     */
    @PostMapping("/promotion/external/findScopeSourcePage")
    Result<PageResult<PromotionScopeSourceVo>> findScopeSourcePage(@RequestBody PromotionScopeSourceVo param);

    /**
     * 分页查询促销政策
     * @param param
     * @return
     */
    @PostMapping("/promotion/v2/findPromotionPageByConditions")
    Result<PageResult<PromotionEditVo>> findPromotionPageByConditionsV2(@RequestBody PromotionEditVo param);

    /**
     * 分页查询促销政策
     * @param param
     * @return
     */
    @PostMapping("/promotion/external/findPromotionPageByConditions")
    Result<PageResult<PromotionEditVo>> findPromotionPageByConditions(@RequestBody PromotionEditVo param);

    /**
     * 根据客户以及商品（本品）查询可用的所有促销政策
     * @param param
     * @return
     */
    @PostMapping("/promotion/external/findAvailablePromotionsByAccount")
    Result<List<PromotionAvailableResp>> findAvailablePromotionsByAccount(@RequestBody PromotionQueryReq param);

    /**
     * 根据促销政策编码列表查询促销政策命中情况
     * @param param
     * @return
     */
    @PostMapping("/promotion/external/findHitPromotionsByPromotionCodes")
    Result<List<PromotionEditVo>> findHitPromotionsByPromotionCodes(@RequestBody PromotionQueryReq param);

    /**
     * 根据促销政策编码列表查询促销政策命中情况
     * @param params
     * @return
     */
    @PostMapping("/promotion/v2/findHitPromotionMapByPromotionCodes")
    Result<Map<String, PromotionEditVo>> findHitPromotionMapByPromotionCodes(@RequestBody ArrayList<PromotionQueryReq> params);

    /**
     * 根据客户查询是否有可用政策
     * @param param
     * @return
     */
    @PostMapping(value = "/promotion/v2/findAvailablePromotionMapByCus")
    Result<Map<String, Boolean>> findAvailablePromotionMapByCus(@RequestBody PromotionQueryReq param);

    /**
     * 审批流回调方法
     *
     * @return
     */
    @Override
    @PostMapping(value = "/promotion/v2/callback")
    Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo);

}
