package com.biz.crm.job;

import com.biz.crm.job.impl.XxlJobFeignImpl;
import com.biz.crm.nebular.job.req.XxlJobInfoReqVo;
import com.biz.crm.nebular.job.resp.XxlJobInfoRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @Description crm-xxl-job
 * @Author Gavin
 * @Date Created in 2021/4/20 下午2:52
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "XxlJobFeign",name="crm-xxl-job",path = "job",fallbackFactory = XxlJobFeignImpl.class)
public interface XxlJobFeign {

    /**
     * 新增定时任务
     */
    @PostMapping("/kms/add")
    Result<XxlJobInfoRespVo> add(@RequestBody XxlJobInfoReqVo params);

    /**
     * 更新定时任务
     */
    @PostMapping("/kms/update")
    Result update(@RequestBody XxlJobInfoReqVo params);

    /**
     * 删除
     */
    @PostMapping("/kms/remove")
    Result remove(@RequestBody List<String> ids);

    /**
     * 启用定时任务
     */
    @PostMapping("/kms/start")
    Result start(@RequestBody List<String> ids);

    /**
     * 禁用定时任务
     */
    @PostMapping("/kms/stop")
    Result pause(@RequestBody List<String> ids);

}