package com.biz.crm.mdm;

import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 一个拥有权限信息的业务系统用户定义feign接口
 *
 * @author zxw
 * @date 2020-09-18 14:06:30
 */


@FeignClient(url = "${feign.urlip:}", qualifier = "mdmCommonUserFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmCommonUserFeign.MdmCommonUserFeignImpl.class)
public interface MdmCommonUserFeign {

    /**
     * 根据id或帐号查询用户
     *
     * @param id       id
     * @param userName 帐号
     * @return result
     */
    @GetMapping("/mdmUserController/detail")
    Result<MdmUserRespVo> detail(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "userName", required = false) String userName);

    @Slf4j
    @Component
    class MdmCommonUserFeignImpl implements FallbackFactory<MdmCommonUserFeign> {

        @Override
        public MdmCommonUserFeign create(Throwable throwable) {
            return (id, userName) -> {
                log.info("查询用户失败,userName:{},error:{}", userName, throwable);
                return new Result<>();
            };
        }
    }
}
