package com.biz.crm.mdm.approval;

import com.biz.crm.mdm.approval.impl.MdmApprovalConfigFeignImpl;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigRedisVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 审批配置主表feign接口
 *
 * @author Tao.Chen
 * @date 2021-03-01 17:50:29
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "mdmApprovalConfigFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmApprovalConfigFeignImpl.class)
public interface MdmApprovalConfigFeign {

    /**
     * 获取redis缓存数据
     */
    @GetMapping("/mdmApprovalConfigController/queryForRedis")
    Result<MdmApprovalConfigRedisVo> queryForRedis(@RequestParam("businessCode") String businessCode);

}
