package com.biz.crm.mdm.approval.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.mdm.approval.MdmApprovalConfigFeign;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigRedisVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 审批配置主表feign接口熔断类
 *
 * @author Tao.Chen
 * @date 2021-03-01 17:50:29
 */
@Slf4j
@Component
public class MdmApprovalConfigFeignImpl extends BaseAbstract implements FallbackFactory<MdmApprovalConfigFeign> {

    @Override
    public MdmApprovalConfigFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmApprovalConfigFeign() {

            @Override
            public Result<MdmApprovalConfigRedisVo> queryForRedis(String businessCode) {
                return doBack();
            }
        };
    }
}
