package com.biz.crm.mdm.availablelist;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.availablelist.impl.AvailableListFeignImpl;
import com.biz.crm.nebular.mdm.availablelist.CusAvailablelistVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/10/13 13:45
 **/
@FeignClient(url ="${feign.urlip:}",qualifier = "availableListFeign",name="crm-mdm",path = "mdm",fallbackFactory = AvailableListFeignImpl.class)
public interface AvailableListFeign {

    /**
     * 批量刷新客户可购清单
     * @param cusCodes 客户编码
     * @return
     */
    @PostMapping(value = "/m/availableList/reFresh/cus")
    Result<Object> reFreshCus(@RequestBody ArrayList<String> cusCodes);

    /**
     * 查询客户可购清单
     * @param cusAvailablelistVo
     * @return
     */
    @PostMapping(value = "/m/availableList/list")
    Result<PageResult<CusAvailablelistVo>> list(@RequestBody CusAvailablelistVo cusAvailablelistVo);

    /**
     * 根据id删除客户可购清单
     * @param id
     * @return
     */
    @GetMapping(value = "/m/availableList/delById/{id}")
    Result<Object> delById(@PathVariable("id") String id);

    /**
     * 根据商品查询客户可购清单
     * @param goodsCodes 商品编码
     * @param cusCode 客户编码
     * @return
     */
    @PostMapping(value = "/m/availableList/findGoodsByCusAndGoodsCodes")
    Result<Map<String, CusAvailablelistVo>> findGoodsByCusAndGoodsCodes(@RequestBody List<String> goodsCodes, @RequestParam("cusCode") String cusCode);

    /**
     * 通过id查询客户可购清单
     * @param id
     * @return
     */
    @GetMapping(value = "/m/availableList/findById/{id}")
    Result<CusAvailablelistVo> findById(@PathVariable("id") String id);

    /**
     * 根据id批量删除客户可购清单
     * @param ids
     * @return
     */
    @PostMapping(value = "/m/availableList/delByIds")
    Result<Object> delByIds(@RequestBody List<String> ids);
}
