package com.biz.crm.mdm.availablelistrule.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.availablelistrule.AvailableListRuleFeign;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import java.util.List;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/10/16 13:40
 **/
@Slf4j
@Component
public class AvailableListRuleFeignImpl extends BaseAbstract implements FallbackFactory<AvailableListRuleFeign> {
    @Override
    public AvailableListRuleFeign create(Throwable throwable){
        log.error("进入熔断",throwable);
        return new AvailableListRuleFeign() {
            @Override
            public Result add(AvailableListRuleVo availableListRuleVo) {
                return doBack();
            }

            @Override
            public Result addForConstract(AvailableListRuleVo availableListRuleVo) {
                return doBack();
            }

            @Override
            public Result edit(AvailableListRuleVo availableListRuleVo) {
                return doBack();
            }

            @Override
            public Result<AvailableListRuleVo> findById(String id) {
                return doBack();
            }

            @Override
            public Result<AvailableListRuleVo> findBySourceId(String sourceId) {
                return doBack();
            }

            @Override
            public Result<PageResult<AvailableListRuleVo>> list(AvailableListRuleVo availableListRuleVo) {
                return doBack();
            }

            @Override
            public Result<Object> delByIds(ArrayList<String> ids) {
                return doBack();
            }

            @Override
            public Result<Object> delByParam(AvailableListRuleVo availableListRuleVo) {
                return doBack();
            }

            /**
             * 根据编码批量查询是否存在
             * @param codes
             * @return
             */
            @Override
            public Result<Map<String, Boolean>> findExistByCodes(List<String> codes) {
                return doBack();
            }
        };
    }
}
