package com.biz.crm.mdm.columnconfig;

import com.biz.crm.mdm.columnconfig.impl.MdmColumnConfigFeignImpl;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 字段配置feign接口
 *
 * @author zxw
 * @date 2020-11-21 12:19:06
 */


@FeignClient(url = "${feign.urlip:}", qualifier = "MdmColumnConfigFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmColumnConfigFeignImpl.class)
public interface MdmColumnConfigFeign {

    @ApiOperation("字段下拉框")
    @PostMapping("/mdmcolumnconfig/columnSelect")
    Result<List<MdmColumnExportRespVo>> columnSelect(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo);

}
